# Proyecto 2.1. El alien toca botón

En esta actividad no vamos a trabajar con bolitas… directamente. 
La idea es que en el tablero hay un alien que para poder activar su nave tiene que 
apretar un botón, para lo cual primero tiene que llegar hasta él. 
Entonces, tu trabajo es fácil: escribí un programa que haga que el alien apriete el botón. 
Fijate que no vas a poder usar los comandos primitivos, sino **procedimientos primitivos** que hablan 
del alien y el botón. Investigá un poco el entorno para encontrarlos.

<center>
![Tablero inicial](data:image/png;base64,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)
</center>

> **El dato**
>
> ¿En qué se diferencian los comandos primitivos y los procedimientos primitivos? 
> Los comandos primitivos, como `Poner`, `Sacar` y `Mover` vienen con Gobstones. 
> En cambio, los **procedimientos primitivos** son _procedimientos_ hechos ad hoc para algunos proyectos, 
> pero no forman parte del lenguaje. De hecho, ¡alguien los programó usando Gobstones!

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/2.Procedimientos/2.1.El%20alien%20toca%20bot%C3%B3n/assets/resources/description.pdf "Enunciado de 'El alien toca botón' en PDF"
